/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

//remove facebook login redirect hash.
if (window.location.hash == '#_=_') {
    window.location.hash = ''; // for older browsers, leaves a # behind
    history.pushState('', document.title, window.location.pathname); // nice and clean
    e.preventDefault(); // no page reload
}


var STBModuleUsers = Object.create(STBModule.prototype);
STBModuleUsers.name="ModuleUsers";


STBModuleUsers.initForms = function() {
        var forgotPass = $("#forgot-password"),
            wgUsLogin = $(".widget-users-login"),
            wgUsRecover = $(".widget-users-recover");
            mdUsLogin = $(".module-users-login"),
            mdUsRecover = $(".module-users-recover");

		if (!(wgUsRecover.length || mdUsRecover.length)){
			forgotPass.remove();
		}

        var slideUpDown = function (e) {
            e.preventDefault();

            if (wgUsLogin.length) {

				wgUsRecover.toggleClass("shown");

				if (wgUsRecover.hasClass("shown")){
					wgUsLogin.slideUp();
					wgUsRecover.slideDown();
				} else {
					wgUsLogin.slideDown();
					wgUsRecover.slideUp();
				}
            } 

			if (mdUsLogin.length) {

				mdUsRecover.toggleClass("shown");

				if (mdUsRecover.hasClass("shown")){
					mdUsLogin.slideUp();
					mdUsRecover.slideDown();
				} else {
					mdUsLogin.slideDown();
					mdUsRecover.slideUp();
				}
            }
        };

 
        if (forgotPass.length > 0) {
            if (!(wgUsRecover.length || $(".module-users-recover").length)) {
                forgotPass.remove();
            }
        }

        forgotPass.on('click', slideUpDown);
        $("#forgot-password-close").on('click', slideUpDown);

		wgUsLogin.siblings(".widget-users-recover").hide();
        mdUsLogin.siblings(".module-users-recover").hide();
}


STBModuleUsers.resendConfirmation = function() {

		var clickUserReconfirm = function (e) {
			try	{
				e.preventDefault();

					
				var form = $(this).closest("form"),
					responsebox = form.find(".responsebox"),
					email = form.find("input[name=email]").val();

				//add sending data if exists
				if (typeof form.attr("data-sending") != "undefined") {
					responsebox.html('<div class="alert alert-loading alert-sending"><p>' + form.attr('data-sending') + '</p></div>');
				}

				var ajaxResend = $.ajax({
					url: "ajax.resend.php?lang=" + ($("html").attr("lang") || "en"),
					type: "post",
					data: "email=" + email
				});

				var doneResend = function (msg) {
					formParseResponse(form , msg )
				};

				ajaxResend.done(doneResend);
				
			}
			catch (e) {
				getStack(0, e);
			}
        };

		$(document).on("click", "a[href=link-module-users-reconfirm]", clickUserReconfirm);
}

STBModuleUsers.runOnReady = function() {
	STBModuleUsers.initForms();
	STBModuleUsers.resendConfirmation();
}

site.registerModule(STBModuleUsers);